/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.util;

import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.BlockEvents;
import io.github.fabricators_of_create.porting_lib.event.common.GrindstoneEvents;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.BlockItemExtensions;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.util.LogicalSidedProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.minecraft.class_1255;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortingHooks {
    public static boolean isCorrectToolForDrops(@NotNull class_2680 state, @NotNull class_1657 player) {
        if (!state.method_29291()) {
            return true;
        }
        return player.method_7305(state);
    }

    public static int onBlockBreakEvent(class_1937 world, class_1934 gameType, class_3222 entityPlayer, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_1792 item = entityPlayer.method_6047().method_7909();
        boolean canAttackBlock = item.method_7885(state, world, pos, (class_1657)entityPlayer);
        return PortingHooks.onBlockBreakEvent(world, gameType, entityPlayer, pos, canAttackBlock);
    }

    public static int onBlockBreakEvent(class_1937 world, class_1934 gameType, class_3222 entityPlayer, class_2338 pos, boolean canAttackBlock) {
        boolean preCancelEvent = false;
        class_1799 itemstack = entityPlayer.method_6047();
        if (!itemstack.method_7960() && !canAttackBlock) {
            preCancelEvent = true;
        }
        if (gameType.method_8387()) {
            if (gameType == class_1934.field_9219) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.method_7294() || !itemstack.method_7960() && itemstack.method_7940(world.method_30349().method_30530(class_7924.field_41254), new class_2694((class_4538)world, pos, false)))) {
                preCancelEvent = true;
            }
        }
        if (world.method_8321(pos) == null) {
            entityPlayer.field_13987.method_14364((class_2596)new class_2626(pos, world.method_8316(pos).method_15759()));
        }
        class_2680 state = world.method_8320(pos);
        BlockEvents.BreakEvent event = new BlockEvents.BreakEvent(world, pos, state, (class_1657)entityPlayer);
        event.setCanceled(preCancelEvent);
        event.sendEvent();
        if (event.isCanceled()) {
            class_2596 pkt;
            entityPlayer.field_13987.method_14364((class_2596)new class_2626((class_1922)world, pos));
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity != null && (pkt = blockEntity.method_38235()) != null) {
                entityPlayer.field_13987.method_14364(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static void init() {
        EntityEvents.ON_JOIN_WORLD.register((entity, world, loadedFromDisk) -> {
            class_1297 newEntity;
            class_1799 stack;
            class_1792 item;
            if (entity.getClass().equals(class_1542.class) && (item = (stack = ((class_1542)entity).method_6983()).method_7909()).hasCustomEntity(stack) && (newEntity = item.createEntity(world, entity, stack)) != null) {
                entity.method_31472();
                class_1255 executor = (class_1255)LogicalSidedProvider.WORKQUEUE.get(world.field_9236 ? EnvType.CLIENT : EnvType.SERVER);
                executor.method_18858((Runnable)new class_3738(0, () -> world.method_8649(newEntity)));
                return false;
            }
            return true;
        });
        RegistryEntryRemovedCallback.event((class_2378)class_7923.field_41178).register((rawId, id, item) -> {
            if (item instanceof BlockItemExtensions) {
                BlockItemExtensions blockItem = (BlockItemExtensions)item;
                blockItem.removeFromBlockToItemMap(class_1792.field_8003, item);
            }
        });
    }

    public static int onGrindstoneChange(@NotNull class_1799 top, @NotNull class_1799 bottom, class_1263 outputSlot, int xp) {
        GrindstoneEvents.OnplaceItem e = new GrindstoneEvents.OnplaceItem(top, bottom, xp);
        if (e.isCanceled()) {
            outputSlot.method_5447(0, class_1799.field_8037);
            return -1;
        }
        if (e.getOutput().method_7960()) {
            return Integer.MIN_VALUE;
        }
        outputSlot.method_5447(0, e.getOutput());
        return e.getXp();
    }

    @Nullable
    public static class_2680 onToolUse(class_2680 originalState, class_1838 context, ToolAction toolAction, boolean simulate) {
        BlockEvents.BlockToolModificationEvent event = new BlockEvents.BlockToolModificationEvent(originalState, context, toolAction, simulate);
        return event.post() ? null : event.getFinalState();
    }
}

